/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public class Player {
    public Connection connection;
    public boolean isRobot;
    public Room room;
    public String playerUID;
    public String playerID;
    public String playerName;
    public String playerEmail;
    public String playerPictureURL;
    public String playerFacebookUserID;
    public String playerTwitterUserID;
    public String playerGoogleUserID;
    public Table table;
    public int randomSeed;

    public Player(Connection connection) {
        this.connection = connection;
        this.isRobot = false;
    }

    public Player(boolean isRobot) {
        this.connection = null;
        this.isRobot = isRobot;
        this.playerUID = "robot";
    }

    public Player createDisconnectedPlayer() {
        Player player = new Player(null);
        player.isRobot = this.isRobot;
        player.room = this.room;
        player.playerUID = this.playerUID;
        player.playerID = this.playerID;
        player.playerName = this.playerName;
        player.playerEmail = this.playerEmail;
        player.playerPictureURL = this.playerPictureURL;
        player.playerFacebookUserID = this.playerFacebookUserID;
        player.playerTwitterUserID = this.playerTwitterUserID;
        player.playerGoogleUserID = this.playerGoogleUserID;
        player.table = this.table;
        player.randomSeed = this.randomSeed;
        return player;
    }

    public void closeConnection() {
        this.connection.close();
        this.connection = null;
    }

    public void sendPlayerJoinedRoomMessage(Player player) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendPlayerJoinedRoomMessage(player);
        }
    }

    public void sendPlayerOpenedTableMessage(Player player, Table table) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendPlayerOpenedTableMessage(player, table);
        }
    }

    public void sendPlayerJoinedTableMessage(Player player, Table joiningTable) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendPlayerJoinedTableMessage(player, joiningTable);
        }
    }

    public void sendPlayerLeftTableMessage(Player player, String tableUID) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendPlayerLeftTableMessage(player, tableUID);
        }
    }

    public void sendRobotJoinedTableMessage(Table table) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendRobotJoinedTableMessage(table);
        }
    }

    public void sendInviteMessage(Player player, Table table) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendInviteMessage(player, table);
        }
    }

    public void sendPlayingStartedMessage(Table table, List<Integer> randomSeeds) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendPlayingStartedMessage(table, randomSeeds);
        }
    }

    public void sendGameMessage(int playIndex, String message) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendGameMessage(playIndex, message);
        }
    }

    public void sendUpdateTimeMessage(int playIndex, int playerIndex, int time) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendUpdateTimeMessage(playIndex, playerIndex, time);
        }
    }

    public void sendChatMessage(String message, int fromPlayerIndex) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendChatMessage(message, fromPlayerIndex);
        }
    }

    public void sendPlayersDisconnectedMessage(List<String> removedPlayerUIDs) {
        if (this.connection != null && !this.isRobot) {
            this.connection.sendPlayersDisconnectedMessage(removedPlayerUIDs);
        }
    }
}

