/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LobbyWebSocketServer {
    public static LobbyWebSocketServer lobbyWebSocketServer;
    public Config config;
    public ConnectionsManager connectionsManager = null;
    private ServerSocket serverSocket = null;
    private ServerSocketChannel serverSocketChannel = null;
    private Map<String, Site> sites;

    public LobbyWebSocketServer(Config config) throws Exception {
        InetAddress inetAddress = null;
        lobbyWebSocketServer = this;
        this.config = config;
        try {
            inetAddress = InetAddress.getByName(config.host);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int port = config.port;
        this.connectionsManager = new ConnectionsManager(this);
        this.connectionsManager.start();
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocket = this.serverSocketChannel.socket();
        this.serverSocket.bind(new InetSocketAddress(inetAddress, port));
    }

    public void start() {
        SocketChannel socketChannel = null;
        while (!this.serverSocket.isClosed()) {
            try {
                socketChannel = this.serverSocketChannel.accept();
                this.connectionsManager.addSocketChannel(socketChannel);
            }
            catch (Exception var5) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public Site getSite(String siteID) {
        Site site;
        if (this.sites == null) {
            this.sites = new HashMap<String, Site>();
        }
        if ((site = this.sites.get(siteID)) != null) {
            return site;
        }
        site = new Site(siteID);
        this.sites.put(siteID, site);
        return site;
    }

    public void removePlayer(Player player) {
        if (player != null && this.sites != null) {
            Collection<Site> sites = this.sites.values();
            for (Site site : sites) {
                site.removePlayer(player);
            }
        }
    }

    public void writeLog(String message) {
    }

    public void writeLog(Exception exception) {
    }

    public static void main(String[] args) throws Exception {
        Config config = new Config();
        new LobbyWebSocketServer(config).start();
    }
}

