/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Frame {
    public static final byte OPTCODE_CONTINUATION = 0;
    public static final byte OPTCODE_TEXT = 1;
    public static final byte OPTCODE_BINARY = 2;
    public static final byte OPTCODE_CLOSE = 8;
    public static final byte OPTCODE_PING = 9;
    public static final byte OPTCODE_PONG = 10;
    private static ByteBuffer byteBufferToSend = null;
    public ByteBuffer byteBuffer;
    public boolean masked;
    public int payloadLength;

    private Frame(ByteBuffer byteBuffer, boolean masked, int payloadLength) {
        this.byteBuffer = byteBuffer;
        this.masked = masked;
        this.payloadLength = payloadLength;
    }

    public boolean getIsFinal() {
        return (this.byteBuffer.get(this.byteBuffer.position()) & 0x80) == 128;
    }

    public boolean getIsPing() {
        return (this.byteBuffer.get(this.byteBuffer.position()) & 0xF) == 9;
    }

    public boolean getIsPong() {
        return (this.byteBuffer.get(this.byteBuffer.position()) & 0xF) == 10;
    }

    public boolean getIsClose() {
        return (this.byteBuffer.get(this.byteBuffer.position()) & 0xF) == 8;
    }

    public String getPayloadAsString() {
        byte[] bytes = this.byteBuffer.array();
        int endIndex = this.byteBuffer.limit();
        if (this.masked) {
            for (int i = 0; i < this.payloadLength; ++i) {
                int var10001;
                int n = var10001 = endIndex - this.payloadLength + i;
                bytes[n] = (byte)(bytes[n] ^ bytes[endIndex - this.payloadLength - 4 + i % 4]);
            }
        }
        try {
            return new String(bytes, endIndex - this.payloadLength, this.payloadLength, "utf-8");
        }
        catch (Exception var5) {
            return null;
        }
    }

    public static ByteBuffer getByteBufferToSend(int minCapacity) {
        if (byteBufferToSend != null && byteBufferToSend.capacity() >= minCapacity) {
            byteBufferToSend.clear();
            return byteBufferToSend;
        }
        byteBufferToSend = ByteBuffer.allocate(minCapacity);
        return byteBufferToSend;
    }

    public static Frame readFrame(ByteBuffer byteBuffer) {
        int startPosition = byteBuffer.position();
        if (byteBuffer.remaining() < 2) {
            return null;
        }
        short theShort = byteBuffer.getShort();
        int payloadLength = theShort & 0x7F;
        if (payloadLength == 126) {
            if (byteBuffer.remaining() < 2) {
                return null;
            }
            payloadLength = byteBuffer.getShort() & 0xFFFFFF;
        } else if (payloadLength == 127) {
            if (byteBuffer.remaining() < 8) {
                return null;
            }
            payloadLength = (int)byteBuffer.getLong();
        }
        boolean masked = (theShort & 0x80) == 128;
        int minRemainingBytes = masked ? 4 + payloadLength : payloadLength;
        if (byteBuffer.remaining() < minRemainingBytes) {
            return null;
        }
        byteBuffer.position(byteBuffer.position() + minRemainingBytes);
        ByteBuffer frameByteBuffer = ByteBuffer.wrap(byteBuffer.array(), startPosition, byteBuffer.position() - startPosition);
        return new Frame(frameByteBuffer, masked, payloadLength);
    }

    public static List<Frame> readFrames(ByteBuffer byteBuffer) {
        Frame frame;
        ArrayList<Frame> frames = new ArrayList<Frame>();
        do {
            if ((frame = Frame.readFrame(byteBuffer)) == null) {
                return null;
            }
            frames.add(frame);
        } while (!frame.getIsFinal());
        return frames;
    }

    public static String getFramesPayloadAsString(List<Frame> frames) {
        if (frames.size() == 1) {
            return frames.get(0).getPayloadAsString();
        }
        int noOfBytes = 0;
        for (Frame frame : frames) {
            noOfBytes += frame.payloadLength;
        }
        byte[] bytes = new byte[noOfBytes];
        int i = 0;
        for (Frame frame : frames) {
            byte[] frameBytes = frame.byteBuffer.array();
            int endIndex = frame.byteBuffer.limit();
            for (int j = 0; j < frame.payloadLength; ++j) {
                bytes[i++] = (byte)(frameBytes[endIndex - frame.payloadLength + j] ^ frameBytes[endIndex - frame.payloadLength - 4 + j % 4]);
            }
        }
        try {
            LobbyWebSocketServer.lobbyWebSocketServer.writeLog("fragmented frame!");
            LobbyWebSocketServer.lobbyWebSocketServer.writeLog(new String(bytes, "utf-8"));
            return new String(bytes, "utf-8");
        }
        catch (Exception var9) {
            return null;
        }
    }

    public static Frame createPongFrame(Frame pingFrame) {
        pingFrame.byteBuffer.put(pingFrame.byteBuffer.position(), (byte)-118);
        return pingFrame;
    }

    public static Frame createPingFrame() {
        ByteBuffer byteBuffer = Frame.getByteBufferToSend(2);
        byteBuffer.put((byte)-119);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        return new Frame(byteBuffer, false, 0);
    }

    public static Frame createCloseFrame() {
        ByteBuffer byteBuffer = Frame.getByteBufferToSend(2);
        byteBuffer.put((byte)-120);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        return new Frame(byteBuffer, false, 0);
    }

    public static Frame createTextFrame(String text) {
        byte[] textBytes;
        try {
            textBytes = text.getBytes("utf-8");
        }
        catch (Exception var4) {
            textBytes = null;
        }
        ByteBuffer byteBuffer = textBytes.length <= 125 ? Frame.getByteBufferToSend(2 + textBytes.length) : (textBytes.length <= 65535 ? Frame.getByteBufferToSend(4 + textBytes.length) : Frame.getByteBufferToSend(10 + textBytes.length));
        byteBuffer.put((byte)-127);
        if (textBytes.length <= 125) {
            byteBuffer.put((byte)textBytes.length);
        } else if (textBytes.length <= 65535) {
            byteBuffer.put((byte)126);
            byteBuffer.putShort((short)textBytes.length);
        } else {
            byteBuffer.put((byte)127);
            byteBuffer.putLong(textBytes.length);
        }
        byteBuffer.put(textBytes);
        byteBuffer.flip();
        return new Frame(byteBuffer, false, textBytes.length);
    }
}

